%       fem1.m
%
% Finite element program for electrostatic problems  
     
    fid=fopen('dat1', 'r');
    fid1=fopen('out1', 'w');
    fid2=fopen('out2', 'w');
    c1=fscanf(fid,'%d', 4);
    nnode=c1(1);
    nelem=c1(2);
    ncon=c1(3);
    nmat=c1(4);
    fprintf(fid1, '%d %d %d %d\n',c1);
    c2=fscanf(fid, '%d', [4 nelem]);
    fprintf(fid1, '%d %d %d %d\n',c2);
    np1=c2(1:3,:);
    mat=c2(4,:);
    np=np1';
    z=fscanf(fid, '%g', [2 nnode]);
    fprintf(fid1, '%g %g\n' ,z);
    x=z(1,:);
    y=z(2,:);  
    nbd=[];
    for i=1:ncon
        v=fscanf(fid, '%g', 1);
        fprintf(fid1, '%g\n' ,v);
        vi(i)=v;
        nn=fscanf(fid, '%d', 20);
        fprintf(fid1, '%d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d\n' ,nn);
        nbd=[nbd,nn];
    end
    nbound=nbd';
    for i=1:nmat
        c1=fscanf(fid, '%f', 2);
        fprintf(fid1, '%f %f\n' ,c1);
        eps(i)=c1(1);
        ro(i)=c1(2);
    end   
  for i=1:nnode
      q(i)=0.;
      for j=1:nnode
          ss(i,j)=0.;
      end
  end

    for i=1:nelem
      n1=np(i,1);
      n2=np(i,2);
      n3=np(i,3);
      nm=mat(i);
%  calculate qi, qj, qk, ri, rj, rk
      q1=y(n2)-y(n3);
      q2=y(n3)-y(n1);
      q3=y(n1)-y(n2);
      r1=x(n3)-x(n2);
      r2=x(n1)-x(n3);
      r3=x(n2)-x(n1);
      xeps=8.854e-12*eps(nm);
        xro=ro(nm);
%  calculate determinant, twice the area of triangle
        det=x(n2)*y(n3)+x(n1)*y(n2)+x(n3)*y(n1)-x(n1)*y(n3)-x(n3)*y(n2)-x(n2)*y(n1);
        coeff=xeps/det/2.;
        coeff1=xro*det/6.;
%  calculate the terms s(3,3)
      s(1,1)=coeff*(q1*q1+r1*r1);
      s(1,2)=coeff*(q1*q2+r1*r2);
      s(1,3)=coeff*(q1*q3+r1*r3);
      s(2,1)=s(1,2);
      s(2,2)=coeff*(q2*q2+r2*r2);
      s(2,3)=coeff*(q2*q3+r2*r3);
      s(3,1)=s(1,3);
      s(3,2)=s(2,3);
      s(3,3)=coeff*(q3*q3+r3*r3);
	qe(1)=coeff1;
	qe(2)=coeff1;
	qe(3)=coeff1;
%  assemble the s(3,3) into the matrix ss(nnode,nnode)
      naux(1)=n1;
      naux(2)=n2;
      naux(3)=n3;
      for k=1:3
        kk=naux(k);
        q(kk)=q(kk)+qe(k);
    for j=1:3
        jj=naux(j);
        ss(kk,jj)=ss(kk,jj)+s(k,j);
    end
      end
    end
% insert boundary conditions
    for i=1:ncon
        for j=1:20
            nox=nbound(i,j);
            if nox~=0
% Either use the next 5 lines (currently used) or use the 6th and 7th
% line (currently commented). The two methods have identical effect but the
% first method produces better conditioned matrices
               for l=1:nnode
                    ss(nox,l)=0.;
                end
                ss(nox,nox)=1.0;
                q(nox)=vi(i);
%                  ss(nox,nox)=1e18;
%                  q(nox)=vi(i)*1e18;
            end     
        end
   end
%  solve the matrix system
vv=ss\q';
for i=1:nnode
    fprintf(fid1,'%1.4e\n' ,vv(i));
    fprintf(fid2,'Node %d V= %1.4e\n' ,i, vv(i));
end
emax=0.0;
      for i=1:nelem
%
% calculate the fields or gradients
%
      n1=np(i,1);
      n2=np(i,2);
      n3=np(i,3);
      q1=y(n2)-y(n3);
      q2=y(n3)-y(n1);
      q3=y(n1)-y(n2);
      r1=x(n3)-x(n2);
      r2=x(n1)-x(n3);
      r3=x(n2)-x(n1);
%  calculate determinant, twice the area of triangle
      det=x(n2)*y(n3)+x(n1)*y(n2)+x(n3)*y(n1)-x(n1)*y(n3)-x(n3)*y(n2)-x(n2)*y(n1);
      ex(i)=-(q1*vv(n1)+q2*vv(n2)+q3*vv(n3))/det;
      ey(i)=-(r1*vv(n1)+r2*vv(n2)+r3*vv(n3))/det;
      emod(i)=sqrt(ex(i)^2+ey(i)^2);
      fprintf(fid1,'%d %1.4e %1.4e %1.4e\n' ,i, ex(i), ey(i), emod(i));
      fprintf(fid2,'Element %d Ex= %1.4e Ey= %1.4e Em= %1.4e\n' ,i, ex(i), ey(i), emod(i));
      end
      ex
      ey
      emod
      vv
     
 
